<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Entity;

interface LinkTypeInterface
{
    /**
     * @return integer
     */
    public function getId();

    /**
     * @return string
     */
    public function getIdentifier();

    /**
     * @return string
     */
    public function getUrl();


    /**
     * @return LinkTypeDetails
     */
    public function getLinkDetails();

    /**
     * @param string          $identifier
     * @param string          $url
     * @return $this
     */
    public function change($identifier, $url, LinkTypeDetails $details);
}
