<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface LanguageInterface
 */
interface LanguageInterface
{
    /**
     * @return int
     */
    public function getId();

    /**
     * @return string
     */
    public function getIso();

    /**
     * @return string
     */
    public function getName();

    /**
     * @return string
     */
    public function getCulture();

    /**
     * @return string
     */
    public function getLocale();

    /**
     * @return string
     */
    public function getTimezone();

    /**
     * Inizializza la lingua.
     *
     * Questo metodo imposta le configurazioni di sistema per la lingua, come il locale ed il timezone.
     *
     * @return $this
     */
    public function startLanguage();

    /**
     * @param int|SiteInterface $site
     * @return LanguageSiteInterface
     */
    public function getLanguageSite($site);
}
