<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\User;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Http\Session;

class UserServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share(
            'session',
            function (Container $container) {
                $options = [
                    'name'            => $container->getParameter('session.name', 'pongho'),
                    'cookie_lifetime' => (int) $container->getParameter('session.cookie_lifetime', 0),
                ];

                if ($options['cookie_lifetime'] > 0) {
                    $options['save_path'] = $container->getParameter('session.save_path', CONTENT_PATH . '/temp');
                }

                $session = new Session($options);
                $session->start();

                return $session;
            }
        );

        $container->share(
            'current_user',
            function (Container $container) {
                return new User(
                    $container->get('session')
                );
            }
        );
    }
}
