<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Console\Command\TranslationDebugCommand;
use Application\Core\Console\Command\TranslationUpdateCommand;
use Application\Core\I18n\Translation\Loader\LocalizationLoader;
use Application\Core\I18n\Translation\Loader\PonghoAppLoader;
use Application\Core\I18n\Translation\Translator;
use Pongho\Core\LocalizationInterface;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class TranslationServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('translator', function (Container $container): LocalizationInterface {
            /** @var \Application\Core\User $user */
            $user = $container->get('current_user');
            $culture = $user->getAccount()->getLanguage()->getCulture();

            $translator = new Translator($culture);

            $translator->addLoader('pongho_app', new PonghoAppLoader());
            $translator->addLoader('localization', new LocalizationLoader($container->get('language')));

            $translator->addResource('pongho_app', 'Core', $culture);
            $translator->addResource('pongho_app', 'Admin', $culture);
            $translator->addResource('localization', null, $culture, 'lang');

            $translator->setFallbackLocales(['it-IT']);

            return $translator;
        });

        $container->extend(
            'console_commands',
            function (\ArrayObject $commands, Container $container): void {
                $commands->append(new TranslationDebugCommand($container->get('translator')));
                $commands->append(new TranslationUpdateCommand());
            },
        );
    }
}
