<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Template\TemplateHelperBuilder;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Template\FooterHelper;
use Pongho\Template\HeadHelper;
use Pongho\Template\Theme;

class TemplatingServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('theme_view', function (Container $container): Theme {
            $class = $container->getParameter('template.theme_class');

            /** @var \Application\Core\Model\Site $site */
            $site = $container->get('site');

            /** @var Theme $theme */
            $theme = new $class($site->getThemesPath());

            $theme->assignVars($container->get('global_view_vars'));

            return $theme;
        });

        $container->set('global_view_vars', function (Container $container): array {
            $vars = [
                'head'     => $container->get('template_head'),
                'footer'   => $container->get('template_footer'),
                'html'     => $container->get('template_html'),
                'lang'     => $container->get('language'),
                'language' => $container->get('language')->getLanguage(),
                'user'     => $container->get('current_user'),
                'site'     => $container->get('site'),
            ];

            if ($container->has('request')) {
                $vars['request'] = $container->get('request');
            }

            return $vars;
        });

        $container->share('template_helper_builder', function (Container $container): TemplateHelperBuilder {
            return new TemplateHelperBuilder(
                $container->get('request'),
                $container->get('site'),
                $container->get('language_site')->getLanguage(),
            );
        });

        $container->share('template_head', function (Container $container): HeadHelper {
            /** @var TemplateHelperBuilder $builder */
            $builder = $container->get('template_helper_builder');

            return $builder->buildHeader();
        });

        $container->share('template_footer', function (Container $container): FooterHelper {
            /** @var TemplateHelperBuilder $builder */
            $builder = $container->get('template_helper_builder');

            return $builder->buildFooter();
        });
    }
}
