<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Utilities\Shortcode;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class ShortcodeServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->share('shortcode', function (Container $container): Shortcode {
            $class = $container->getParameter('shortcode.shortcode_class');

            return new $class();
        });

        $container->extend(
            'shortcode',
            function (Shortcode $shortcode, Container $container): void {
                /** @var $site \Application\Core\Model\Site */
                $site = $container->get('site');

                /** @var $view \Pongho\Template\Theme */
                $view = $container->get('theme_view');

                $shortcode
                    ->add('config', function (array $attributes, $content, $tag_name) use ($site) {
                        if (!array_key_exists('key', $attributes)) {
                            return false;
                        }

                        $attribute = substr((string) $attributes['key'], 5);

                        if ($attribute && $site->attributePresent($attribute)) {
                            return $site->$attribute;
                        }

                        return $site->getOption($attributes['key']);
                    })
                    ->add('include', function (array $attributes, $content, $tag_name) use ($view) {
                        if (!array_key_exists('template', $attributes)) {
                            throw new \InvalidArgumentException(
                                sprintf('Parameter "template" is required in %s shortcode!', $tag_name),
                            );
                        }

                        // Vista
                        $view
                            ->setTemplate("snippets/{$attributes['template']}.php")
                            ->assignVar('attrs', $attributes);

                        return $view->render();
                    });
            },
        );
    }
}
