<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Sdk\GoogleAnalytics\MeasurementProtocol\Client\GuzzleClient;
use Pongho\Sdk\GoogleAnalytics\MeasurementProtocol\MeasurementProtocol;

class SdkServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share(
            'sdk.google_analytics_measurement_protocol',
            function (Container $container): MeasurementProtocol {
                /**
                 * @var \Application\Core\Model\Site $site
                 * @var \Pongho\Http\Request         $request
                 */
                $site = $container->get('site');
                $request = $container->get('request');

                return new MeasurementProtocol(
                    $site->getOption('google_analytics'),
                    new GuzzleClient($request->headers->get('User-Agent')),
                );
            },
        );
    }
}
