<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

declare(strict_types=1);

namespace Application\Core\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Template\HeadHelper;

final class Recaptcha3ServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->extend('template_head', function (HeadHelper $helper, Container $container): void {
            $site_key = $container->get('site')->getOption('recaptcha3_site_key');
            $secret_key = $container->get('site')->getOption('recaptcha3_secret_key');

            if ($site_key && $secret_key) {
                $helper->javascript->add(
                    'https://www.google.com/recaptcha/api.js?' . http_build_query(['render' => $site_key]),
                );
            }
        });
    }
}
