<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Mailer\Helper;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Symfony\Component\Mailer\Mailer as SymfonyMailer;
use Symfony\Component\Mailer\Transport;
use Symfony\Component\Mailer\Transport\TransportInterface;

class MailerServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share(SymfonyMailer::class, function (Container $container): SymfonyMailer {
            return new SymfonyMailer(
                $container->get(TransportInterface::class)
            );
        });

        $container->share(TransportInterface::class, function (Container $container): TransportInterface {
            return Transport::fromDsn(
                $container->get('mailer_dsn')
            );
        });

        $container->share('mailer_dsn', function (Container $container): string {
            if ($container->get('kernel')->getEnvironment() === 'dev') {
                return 'native://default';
            }

            return 'smtp://postal.rackone.ch:25';
        });

        $container->share(Helper::class, function (Container $container): Helper {
            return new Helper(
                $container->get('site'),
                $container->get('translator')
            );
        });
    }
}
