<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Controller\LinkedInAuthController;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Routing\Route;
use Pongho\Routing\RoutesCollection;

final class LinkedinServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->extend('routes_collection', function (RoutesCollection $collection): void {
            $collection->add(
                'user.linkedin',
                new Route('/user/linkedin-{_action}/', [
                    '_controller' => LinkedInAuthController::class,
                ])
            );
        });
    }
}
