<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * @todo: Sperimentale
 */
class FormProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->set('form_login', $this->getUserLoginFormService(...));
        $container->set('form_subscribe', $this->getUserSubscribeFormService(...));
        $container->set('form_user_settings', $this->getUserSettingsFormService(...));
        $container->set('form_forgot_password', $this->getUserForgotPasswordFormService(...));
        $container->set('form_reset_password', $this->getUserResetPasswordFormService(...));
    }

    /**
     * Idea da implementare.
     *
     * @return \Pongho\Form\Form
     * @internal
     */
    public function getUserLoginFormService(Container $container)
    {
        $class = $container->getParameter('user.login_form_class');

        return $class::create($container->get('request'));
    }

    /**
     * Idea da implementare.
     *
     * @return \Pongho\Form\Form
     * @internal
     */
    public function getUserSubscribeFormService(Container $container)
    {
        $class = $container->getParameter('user.subscribe_form_class');

        return $class::create($container->get('request'));
    }

    /**
     * Idea da implementare.
     *
     * @return \Pongho\Form\Form
     * @internal
     */
    public function getUserSettingsFormService(Container $container)
    {
        $class = $container->getParameter('user.settings_form_class');

        return $class::create($container->get('request'));
    }

    /**
     * Idea da implementare.
     *
     * @return \Pongho\Form\Form
     * @internal
     */
    public function getUserForgotPasswordFormService(Container $container)
    {
        $class = $container->getParameter('user.forgot_password_form_class');

        return $class::create($container->get('request'));
    }

    /**
     * Idea da implementare.
     *
     * @return \Pongho\Form\Form
     * @internal
     */
    public function getUserResetPasswordFormService(Container $container)
    {
        $class = $container->getParameter('user.reset_password_form_class');

        return $class::create($container->get('request'));
    }
}
