<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Console\Command\TaskCommand;
use Application\Core\Cron\TaskRepository;
use Application\Core\Cron\TaskRunner;
use ArrayObject;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class CronServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('cron.task_repository', function (Container $container): TaskRepository {
            return new TaskRepository($container->get('connection'));
        });

        $container->share('cron.task_runner', function (Container $container): TaskRunner {
            return new TaskRunner(
                $container->get('cron.task_repository'),
                $container,
                $container->get('logger')
            );
        });

        $container->extend(
            'console_commands',
            function (ArrayObject $commands, Container $container): void {
                $commands->append(new TaskCommand($container->get('cron.task_runner')));
            }
        );
    }
}
