<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\CommandBus\ContainerLocator;
use League\Tactician\CommandBus;
use League\Tactician\Handler\CommandHandlerMiddleware;
use League\Tactician\Handler\CommandNameExtractor\ClassNameExtractor;
use League\Tactician\Handler\CommandNameExtractor\CommandNameExtractor;
use League\Tactician\Handler\Locator\HandlerLocator;
use League\Tactician\Handler\MethodNameInflector\HandleInflector;
use League\Tactician\Handler\MethodNameInflector\MethodNameInflector;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class CommandBusServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('command_bus', function (Container $container): CommandBus {
            return new CommandBus(
                $container->get('command_bus.middleware')
            );
        });

        $container->share('command_bus.middleware', function (Container $container): array {
            return [
                new CommandHandlerMiddleware(
                    $container->get('command_bus.command_name_extractor'),
                    $container->get('command_bus.handler_locator'),
                    $container->get('command_bus.method_name_inflector')
                ),
            ];
        });

        $container->share('command_bus.command_name_extractor', function (): CommandNameExtractor {
            return new ClassNameExtractor();
        });

        $container->share('command_bus.handler_locator', function (Container $container): HandlerLocator {
            return new ContainerLocator($container);
        });

        $container->share('command_bus.method_name_inflector', function (): MethodNameInflector {
            return new HandleInflector();
        });
    }
}
