<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Console\Command\CacheClearCommand;
use ArrayObject;
use Pongho\Caching\FileCache;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class CachingServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('cache', function (): FileCache {
            return new FileCache('pongho', CACHE_PATH);
        });

        $container->extend(
            'console_commands',
            function (ArrayObject $commands, Container $container): void {
                $commands->append(new CacheClearCommand($container->get('cache')));
            },
        );
    }
}
