<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\Application\CliLoader;
use Application\Core\Application\Facade;
use Application\Core\Application\Finder;
use Application\Core\Application\LoaderInterface;
use Application\Core\Application\SiteLoader;
use Application\Core\Console\Command\ApplicationDisableCommand;
use Application\Core\Console\Command\ApplicationEnableCommand;
use Application\Core\Console\Command\ApplicationInstallCommand;
use Application\Core\Console\Command\ApplicationUninstallCommand;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class ApplicationServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container)
    {
        $container->share(
            'application_loader',
            function (Container $container): LoaderInterface {
                if (PHP_SAPI === 'cli') {
                    return new CliLoader($container, $container->get('application_manager'));
                }

                return new SiteLoader($container, $container->get('application_manager'), $container->getParameter('site_id'));
            }
        );

        $container->share(
            'application_finder',
            function (): Finder {
                return new Finder();
            }
        );

        $container->share(
            'application_facade',
            function (Container $container): Facade {
                return new Facade(
                    $container->get('application_manager'),
                    $container->get('application_loader'),
                    $container->get('application_finder'),
                    $container->get('translator')
                );
            }
        );

        $container->extend(
            'console_commands',
            function (\ArrayObject $commands, Container $container): void {
                $commands->append(new ApplicationInstallCommand($container->get('application_facade')));
                $commands->append(new ApplicationEnableCommand($container->get('application_facade')));
                $commands->append(new ApplicationDisableCommand($container->get('application_facade')));
                $commands->append(new ApplicationUninstallCommand($container->get('application_facade')));
            }
        );
    }
}
