<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Admin\AdminSidebar\Sidebar;
use Application\Core\Controller\Admin\AppsController;
use Application\Core\Controller\Admin\GroupsController;
use Application\Core\Controller\Admin\LanguagesController;
use Application\Core\Controller\Admin\NotificationsTemplatesController;
use Application\Core\Controller\Admin\PermitsController;
use Application\Core\Controller\Admin\RolesController;
use Application\Core\Controller\Admin\SettingsController;
use Application\Core\Controller\Admin\SitesController;
use Application\Core\Controller\Admin\TranslationsController;
use Application\Core\Controller\Admin\UsersController;
use Application\Core\Controller\Admin\UsersImportController;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

final class AdminSidebarServiceProvider implements ServiceProviderInterface
{
    public function register(Container $container)
    {
        $container->extend('admin_sidebar', function (Sidebar $sidebar, Container $container): void {
            /** @var \Application\Core\I18n\Translation\Translator $translator */
            $translator = $container->get('translator');

            /** @var \Application\Core\User $user */
            $user = $container->get('current_user');

            if ($user->hasPermit('users.admin')) {
                $sidebar->addPanel($translator->trans('Users'), 'users', 'users', Sidebar::POS_BOTTOM);

                $sidebar->addItem(
                    $translator->trans('List'),
                    '/users/',
                    'users',
                    Sidebar::POS_PANEL_ACTIONS,
                    UsersController::class
                );

                if ($user->hasPermit('users.add')) {
                    $sidebar->addItem(
                        $translator->trans('Add'),
                        '/users/add/',
                        'users',
                        Sidebar::POS_PANEL_ACTIONS,
                        UsersController::class
                    );
                }

                if ($user->hasPermit('users.handle_roles')) {
                    $sidebar->addItem(
                        $translator->trans('Roles'),
                        '/roles/',
                        'users',
                        Sidebar::POS_PANEL_FEATURES,
                        RolesController::class
                    );
                }

                if ($user->hasPermit('users.handle_groups')) {
                    $sidebar->addItem(
                        $translator->trans('Groups'),
                        '/groups/',
                        'users',
                        Sidebar::POS_PANEL_FEATURES,
                        GroupsController::class
                    );
                }

                if ($user->isFounder()) {
                    $sidebar->addItem(
                        $translator->trans('Import users'),
                        '/users-import/',
                        'users',
                        Sidebar::POS_PANEL_SETTINGS,
                        UsersImportController::class
                    );
                }
            }

            if ($user->hasPermit('admin.options.translations')) {
                $sidebar->addItem(
                    $translator->trans('Translations configuration'),
                    '/translations/',
                    'options',
                    Sidebar::POS_PANEL_FEATURES,
                    TranslationsController::class
                );
            }

            if ($user->hasPermit('admin.options.notifications')) {
                $sidebar->addItem(
                    $translator->trans('Notification templates'),
                    '/notifications/',
                    'options',
                    Sidebar::POS_PANEL_SETTINGS,
                    NotificationsTemplatesController::class
                );
            }

            if ($user->isFounder()) {
                $sidebar->addItem(
                    $translator->trans('Site configuration'),
                    '/settings/',
                    'settings',
                    Sidebar::POS_PANEL_FEATURES,
                    SettingsController::class
                );

                $sidebar->addItem(
                    $translator->trans('Languages configuration'),
                    '/languages/',
                    'settings',
                    Sidebar::POS_PANEL_FEATURES,
                    LanguagesController::class
                );

                $sidebar->addItem(
                    $translator->trans('Permits'),
                    '/permits/',
                    'settings',
                    Sidebar::POS_PANEL_FEATURES,
                    PermitsController::class
                );

                $sidebar->addItem(
                    $translator->trans('Applications configuration'),
                    '/apps/',
                    'settings',
                    Sidebar::POS_PANEL_FEATURES,
                    AppsController::class
                );
            }

            // Rotte per la gestione del multisito e dei widget in bacheca.
            $sidebar->addRoute('/sites/', SitesController::class);
        });
    }
}
