<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\DependencyInjection;

use Application\Core\I18n\Address\AddressRendererFactory;
use Application\Core\I18n\Address\AddressValidatorFactory;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class AddressProvider implements ServiceProviderInterface
{
    public function register(Container $container): void
    {
        $container->share('address_validator_factory', function (): AddressValidatorFactory {
            return new AddressValidatorFactory();
        });

        $container->share('address_renderer_factory', function (): AddressRendererFactory {
            return new AddressRendererFactory();
        });
    }
}
