<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Db\Maintainer;

final class TaskList implements \IteratorAggregate, \Countable
{
    /**
     * @var TaskInterface[]
     */
    private $list = [];

    /**
     * @return $this
     */
    public function registerTask(TaskInterface $task)
    {
        $this->list[] = $task;

        return $this;
    }

    /**
     * Executes all tasks.
     */
    public function execute()
    {
        foreach ($this->list as $task) {
            $task->execute();
        }
    }

    public function getIterator(): \Traversable
    {
        return new \ArrayIterator($this->list);
    }

    public function count(): int
    {
        return count($this->list);
    }
}
