<?php

/**
 * Questo file è parte di Pongho 2.0-dev.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Controller\Admin;

use Application\Admin\Controller\SiteOptionsController;

class SettingsController extends SiteOptionsController
{
    /**
     * Tab principale
     */
    public function indexAction()
    {
        $site = $this->getHelper()->getSite();

        if ($this->getRequest()->getMethod() === 'POST' && isset($_POST['site']) && is_array($_POST['site'])) {
            $site->updateAttributes($_POST['site']);
        }

        $this->handleRequest([
            'site_name'              => 'text',
            'site_domain'            => 'text',
            'default_language'       => 'integer',
            'subscription_mode'      => 'text',
            'account_url'            => 'boolean',
            'slogan'                 => 'text',
            'recaptcha2_private_key' => 'text',
            'recaptcha2_public_key'  => 'text',
            'recaptcha3_site_key'    => 'text',
            'recaptcha3_secret_key'  => 'text',
            'google_maps_api_key'    => 'text',
        ]);

        $this->getHelper()->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/settings_main.php')
            ->assignVars([
                'action_form' => $this->url('/' . $this->getParameter('path') . '/'),
                'site'        => $site,
                'config_dev'  => $this->getConfigDev(),
            ]);

        $this->displayTabs();
    }

    /**
     * Tab company
     */
    public function companyAction()
    {
        $site = $this->getHelper()->getSite();

        if ($this->getRequest()->getMethod() === 'POST' && isset($_POST['site']) && is_array($_POST['site'])) {
            $site->updateAttributes($_POST['site']);
        }

        $this->handleRequest([
            'company_name'           => 'text',
            'company_type'           => 'text',
            'company_ceo_name'       => 'text',
            'company_address'        => 'text',
            'company_postcode'       => 'text',
            'company_city'           => 'text',
            'company_city_link'      => 'text',
            'company_province'       => 'text',
            'company_province_plate' => 'text',
            'company_country'        => 'text',
            'company_partita_iva'    => 'text',
            'company_codice_fiscale' => 'text',
            'company_rea'            => 'text',
            'company_camera'         => 'text',
            'company_cap_soc'        => 'text',
            'company_website'        => 'text',
            'company_email'          => 'text',
            'company_tel'            => 'text',
            'company_tel2'           => 'text',
            'company_tel3'           => 'text',
            'company_fax'            => 'text',
            'company_fax2'           => 'text',
            'company_fax3'           => 'text',
            'company_copyright'      => 'text',
            // Google Maps
            'company_latitude'       => 'text',
            'company_longitude'      => 'text',
        ]);

        $this->getHelper()->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/settings_company.php')
            ->assignVars([
                'action_form' => $this->url('/' . $this->getParameter('path') . '/company/'),
                'site'        => $site,
                'config_dev'  => $this->getConfigDev(),
            ]);

        $this->displayTabs();
    }

    /**
     * Tab social
     */
    public function socialAction()
    {
        $site = $this->getHelper()->getSite();

        if ($this->getRequest()->getMethod() === 'POST' && isset($_POST['site']) && is_array($_POST['site'])) {
            $site->updateAttributes($_POST['site']);
        }

        $this->handleRequest([
            'fb'                     => 'boolean',
            'fb_comments'            => 'boolean',
            'fb_appid'               => 'text',
            'fb_appsecret'           => 'text',
            'fb_admin_id'            => 'text',
            'fb_og_type'             => 'text',
            'linkedin_client_id'     => 'text',
            'linkedin_client_secret' => 'text',
        ]);

        $this->getHelper()->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/settings_social.php')
            ->assignVars([
                'action_form' => $this->url('/' . $this->getParameter('path') . '/social/'),
                'site'        => $site,
            ]);

        $this->displayTabs();
    }

    /**
     * Tab dashboard
     */
    public function dashboardAction()
    {
        $this->handleRequest([
            'gapi_view_id' => 'text',
        ]);

        $this->getHelper()->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/settings_dashboard.php')
            ->assignVars([
                'action_form' => $this->url('/' . $this->getParameter('path') . '/dashboard/'),
            ]);

        $this->displayTabs();
    }

    /**
     * Visualizza le tabs con le varie categorie di opzione
     */
    protected function displayTabs()
    {
        $this->getHelper()->getBodyView()
            ->assignVar('tabs', $this->getTabs());
    }

    /**
     * Restituisce le tabs disponibili
     *
     * @return array
     */
    protected function getTabs()
    {
        $translator = $this->getHelper()->getTranslator();
        $path = $this->getParameter('path');

        return [
            (object) [
                'name'      => $translator->trans('Main'),
                'link'      => $this->url("/{$path}/"),
                'is_active' => ($this->getAction() == 'index'),
            ],
            (object) [
                'name'      => $translator->trans('Company'),
                'link'      => $this->url("/{$path}/company/"),
                'is_active' => ($this->getAction() == 'company'),
            ],
            (object) [
                'name'      => $translator->trans('Social'),
                'link'      => $this->url("/{$path}/social/"),
                'is_active' => ($this->getAction() == 'social'),
            ],
            (object) [
                'name'      => $translator->trans('Dashboard'),
                'link'      => $this->url("/{$path}/dashboard/"),
                'is_active' => ($this->getAction() == 'dashboard'),
            ],
        ];
    }

    /**
     * @return array
     */
    private function getConfigDev()
    {
        if (file_exists(CONFIG_PATH . '/config_dev.php')) {
            return include CONFIG_PATH . '/config_dev.php';
        }

        return [];
    }
}
