<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core;

use Pongho\Core\TemplateResponse;
use Pongho\Http\Response;
use Pongho\Utilities\Inflector;

/**
 * Controller base.
 */
class Controller extends BaseController
{
    /**
     * {@inheritdoc}
     */
    protected function handleInvalidResponse($response): Response
    {
        $view = $this->getHelper()->getTheme();

        // Se il template non ha un filename impostato, lo imposto in base al nome del controller e dell'azione eseguita.
        if (!$view->hasTemplate()) {
            $controllerBase = substr(static::class, 0, -10);
            $controllerBase = Inflector::underscore(Inflector::demodulize($controllerBase));

            if ($this->getAction() === 'index') {
                $view->setTemplate($controllerBase . '.php');
            } else {
                $view->setTemplate($controllerBase . '_' . $this->getAction() . '.php');
            }
        }

        return new TemplateResponse($view, $this->getHelper()->getResponseHeaders());
    }

    /**
     * Restituisce la vista.
     *
     * @return \Pongho\Template\Theme
     *
     * @deprecated
     */
    public function getView()
    {
        return $this->getHelper()->getTheme();
    }

    /**
     * {@inheritdoc}
     *
     * @deprecated
     */
    public function displayMessage($message, $isError = false, array $parameters = [])
    {
        return $this->getHelper()->displayMessage($message, $isError, $parameters);
    }
}
