<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Console\Command;

use Application\Core\Db\Maintainer\TaskList;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Helper\ProgressBar;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class DbClearCommand extends Command
{
    /**
     * @var TaskList
     */
    private $taskList;

    public function __construct(TaskList $taskList)
    {
        $this->taskList = $taskList;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('db:clear')
            ->setDescription('Clears the database from garbage data.');
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $progressBar = new ProgressBar($output, $this->taskList->count());
        $progressBar->start();

        /** @var \Application\Core\Db\Maintainer\TaskInterface $task */
        foreach ($this->taskList as $task) {
            $task->execute();
            $progressBar->advance();
        }

        $progressBar->finish();

        return Command::SUCCESS;
    }
}
