<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Console\Command;

use Application\Core\Utilities\ChangeDomainHandler;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class ChangeDomainCommand extends Command
{
    /**
     * @var ChangeDomainHandler
     */
    private $handler;

    public function __construct(ChangeDomainHandler $handler)
    {
        $this->handler = $handler;

        parent::__construct();
    }

    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('site:change-domain')
            ->setDescription('Change the domain of the site.')
            ->setDefinition([
                new InputArgument('old-domain', InputArgument::REQUIRED, 'The old domain'),
                new InputArgument('new-domain', InputArgument::REQUIRED, 'The new domain'),
            ]);
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->handler->changeDomain($input->getArgument('old-domain'), $input->getArgument('new-domain'));

        $output->writeln('Domain changed.');

        return Command::SUCCESS;
    }
}
