<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Console\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * @todo: Rendere obbligatoria l'opzione del sito quando il nuovo creator entrerà a regime.
 */
class ApplicationEnableCommand extends AbstractApplicationCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('application:enable')
            ->setDescription('Enables an application')
            ->addArgument(
                'application',
                InputArgument::REQUIRED,
                'The name of the application being enabled'
            )
            ->addArgument(
                'site',
                InputArgument::OPTIONAL,
                'The site ID',
                1
            )
        ;
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->facade->enable($input->getArgument('application'), $input->getArgument('site'));

        return Command::SUCCESS;
    }
}
