<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\CommandBus;

use League\Tactician\Exception\MissingHandlerException;
use League\Tactician\Handler\Locator\HandlerLocator;
use Pongho\DependencyInjection\Container;

class ContainerLocator implements HandlerLocator
{
    public const SERVICE_PREFIX = 'command_bus.handlers.';

    /**
     * @var Container
     */
    protected $container;

    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * {@inheritdoc}
     */
    public function getHandlerForCommand($commandName)
    {
        $serviceName = self::SERVICE_PREFIX . $commandName;

        if ($this->container->has($serviceName)) {
            return $this->container->get($serviceName);
        }

        throw MissingHandlerException::forCommand($commandName);
    }
}
