<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Breadcrumb;

class Crumb implements CrumbInterface
{
    /**
     * @var string
     */
    protected $id;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $permalink;

    /**
     * @param string $id
     * @param string $title
     * @param string $permalink
     */
    public function __construct($id, $title, $permalink)
    {
        $this->id = (string) $id;
        $this->title = (string) $title;
        $this->permalink = (string) $permalink;
    }

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * {@inheritdoc}
     */
    public function getPermalink()
    {
        return $this->permalink;
    }
}
