<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core;

use ActiveRecord\Errors;
use Pongho\Core\Controller;

/**
 * Controller base.
 *
 * Rappresenta un primo livello da estendere per i vari controller delle applicazioni.
 *
 * @method Utilities\ControllerHelper getHelper()
 */
abstract class BaseController extends Controller
{
    /**
     * Resituisce il modello del sito corrente.
     *
     * @return \Application\Core\Model\Site
     *
     * @deprecated
     */
    public function getSite()
    {
        return $this->getHelper()->getSite();
    }

    /**
     * Restituisce l’ID del sito corrente.
     *
     * @return int
     */
    public function getSiteId()
    {
        return $this->getHelper()->getSite()->id;
    }

    /**
     * Restituisce il modulo legato al sito.
     *
     * @param bool $thrown_exception
     * @return \Application\Core\Model\ModuleSite
     *
     * @deprecated
     */
    public function getSiteModule($thrown_exception = true)
    {
        return $this->getHelper()->getModuleSite($thrown_exception);
    }

    /**
     * Restituisce l’ID del modulo legato al sito.
     *
     * @return int
     *
     * @deprecated
     */
    public function getSiteModuleId()
    {
        return $this->getHelper()->getModuleSite()->id;
    }

    /**
     * Restituisce l’utente.
     *
     * @return User
     *
     * @deprecated
     */
    public function getUser()
    {
        return $this->getHelper()->getUser();
    }

    /**
     * Restituisce la sessione.
     *
     * @return \Pongho\Http\Session
     */
    public function getSession()
    {
        return $this->getContainer()->get('session');
    }

    /**
     * Restituisce la localizzazione.
     *
     * @return Localization
     *
     * @deprecated
     */
    public function getLocalization()
    {
        return $this->getHelper()->getLocalization();
    }

    /**
     * Restituisce la lingua.
     *
     * @return Localization
     *
     * @deprecated
     */
    public function getLang()
    {
        return $this->getHelper()->getLocalization();
    }

    /**
     * Restituisce il modello della lingua.
     *
     * @return \Application\Core\Model\LanguageSite
     *
     * @deprecated
     */
    public function getLanguage()
    {
        return $this->getHelper()->getLanguage();
    }

    /**
     * Restituisce il formato iso della lingua.
     *
     * @return string
     */
    public function getLanguageIso()
    {
        return $this->getHelper()->getLanguage()->iso;
    }

    /**
     * Restituisce l’ID della lingua (language_id).
     *
     * @return int
     */
    public function getLanguageId()
    {
        return $this->getHelper()->getLanguage()->language_id;
    }

    /**
     * Restituisce il path della lingua (language_path).
     *
     * @return int
     */
    public function getLanguagePath()
    {
        return $this->getHelper()->getLanguage()->path;
    }

    /**
     * Restituisce la vista.
     *
     * @return \Pongho\Template\HeadHelper
     *
     * @deprecated
     */
    public function getHead()
    {
        return $this->getHelper()->getThemeHeaderHelper();
    }

    /**
     * Visualizza un messaggio.
     *
     * @param string  $message
     * @param boolean $isError
     * @return \Pongho\Http\Response
     * @deprecated
     */
    public function displayMessage($message, $isError = false, array $parameters = [])
    {
        return $this->getHelper()->displayMessage($message, $isError, $parameters);
    }

    /**
     * Visualizza un messaggio in formato JSON.
     *
     * @param string  $message
     * @param boolean $isError
     * @return \Pongho\Http\Response
     * @deprecated
     */
    public function displayJsonMessage($message, $isError = false, array $parameters = [])
    {
        return $this->getHelper()->displayJsonMessage($message, $isError, $parameters);
    }

    /**
     * Visualizza un messaggio di errore.
     *
     * @param string $message
     * @return \Pongho\Http\Response
     * @deprecated
     */
    public function displayError($message, array $parameters = [])
    {
        return $this->getHelper()->displayMessage($message, true, $parameters);
    }

    /**
     * Visualizza un messaggio di errore in formato JSON.
     *
     * @param string $message
     * @return \Pongho\Http\Response
     * @deprecated
     */
    public function displayJsonError($message, array $parameters = [])
    {
        return $this->getHelper()->displayJsonMessage($message, true, $parameters);
    }

    /**
     * Restituisce una risposta per un redirect all’url passato.
     *
     * Questo metodo tiene conto anche delle richieste AJAX.
     *
     * @param string $redirectUrl
     * @return \Pongho\Http\Response
     *
     * @deprecated
     */
    public function redirectResponse($redirectUrl)
    {
        return $this->getHelper()->redirectResponse($redirectUrl);
    }

    /**
     * Elabora gli errori generati da un modello per ottenere la versione tradotta.
     *
     * @return array
     */
    protected function translateErrors(Errors $modelErrors)
    {
        $errors = [];
        foreach ($modelErrors->all_as_hash() as $field => $error) {
            $errors[$field] = $this->getHelper()->getLocalization()->get($error);
        }

        return $errors;
    }
}
