<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Application;

use Application\Core\Model\Manager\ApplicationManagerInterface;
use Pongho\DependencyInjection\Container;

class SiteLoader extends AbstractLoader
{
    /**
     * @var ApplicationManagerInterface
     */
    protected $manager;

    /**
     * @var int
     */
    protected $site_id;

    /**
     * @param int                         $site_id
     */
    public function __construct(Container $container, ApplicationManagerInterface $manager, $site_id)
    {
        parent::__construct($container);

        $this->manager = $manager;
        $this->site_id = $site_id;
    }

    /**
     * @return \Application\Core\Entity\ApplicationInterface[]
     */
    protected function getApplications()
    {
        return $this->manager->allEnabled($this->site_id);
    }
}
