<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Application;

class Finder implements FinderInterface
{
    /**
     * {@inheritdoc}
     */
    public function find()
    {
        $kernels_path = PONGHO_PATH . '/Application/*/Kernel.php';
        $base_path_length = strlen(PONGHO_PATH) + 1;

        $apps = [];
        foreach (glob($kernels_path) as $kernel_file) {
            $kernel_class = str_replace('/', '\\', substr($kernel_file, $base_path_length, -4));

            $segments = explode('\\', $kernel_class);
            $apps[] = $segments[1];
        }

        return $apps;
    }
}
