<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Application;

use Application\Core\Model\Manager\Exception\ApplicationManagerKernelException;
use Pongho\DependencyInjection\Container;

/**
 * Loader.
 */
abstract class AbstractLoader implements LoaderInterface
{
    /**
     * @var \Pongho\DependencyInjection\Container
     */
    protected $container;

    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * {@inheritdoc}
     */
    public function getKernelClass($app_name)
    {
        return 'Application\\' . $app_name . '\\Kernel';
    }

    /**
     * {@inheritdoc}
     */
    public function kernelExists($app_name)
    {
        return class_exists($this->getKernelClass($app_name));
    }

    /**
     * {@inheritdoc}
     */
    public function load()
    {
        // carico le applicazioni
        foreach ($this->getApplications() as $app) {
            try {
                $kernel = $this->getKernel($app->getName());

                if ($kernel->isRunnable()) {
                    $kernel->load();
                }
            } catch (\Exception $e) {
                if ($this->container->get('kernel')->isDebug()) {
                    throw new \RuntimeException(sprintf(
                        'Application "%s" thrown an exception with message: %s',
                        $app->getName(),
                        $e->getMessage()
                    ), $e->getCode(), $e);
                }
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public function getKernel($app_name)
    {
        // Creo il nome del kernel
        $kernel_class = $this->getKernelClass($app_name);

        if (!class_exists($kernel_class)) {
            throw new ApplicationManagerKernelException(
                sprintf('The kernel for application "%s" not exists.', $app_name)
            );
        }

        if (!defined("{$kernel_class}::VERSION")) {
            throw new ApplicationManagerKernelException(
                sprintf('The application "%s" kernel lacks the version.', $app_name)
            );
        }

        return new $kernel_class($this->container);
    }

    /**
     * @return \Application\Core\Entity\ApplicationInterface[]
     */
    abstract protected function getApplications();
}
