<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\AccountContext\UseCase\UploadAvatar;

use Application\Core\Model\File;
use Application\Core\Model\Site;
use Pongho\FileUploader\Exception\FileUploaderException;
use Pongho\FileUploader\FileUploader;

class UploadAvatarUseCase
{
    /**
     * @var Site
     */
    private $site;

    public function __construct(Site $site)
    {
        $this->site = $site;
    }

    /**
     * @return UploadAvatarResponse
     */
    public function uploadAvatar(UploadAvatarRequest $request)
    {
        try {
            $uploader = new FileUploader($request->getRequestFile());

            $uploader
                ->setPath($this->site->getUploadsPath('avatars'))
                ->setAllowedExtensions(['jpg', 'jpeg', 'gif', 'png'])
                ->setMaxFileSize(102400)// 100 KB
                ->setFileName($request->getAccount()->getId() . '-' . time())
                ->upload();
        } catch (FileUploaderException $fileUploaderException) {
            return UploadAvatarResponse::createFailureResponse($fileUploaderException);
        }

        $attributes = $uploader->getFileData();
        $attributes['site_id'] = $this->site->getId();
        $attributes['path'] = substr((string) $attributes['path'], strlen($this->site->getUploadsPath()));

        $oldAvatar = $request->getAccount()->getUserDetails()->getAvatar();

        if ($oldAvatar === null) {
            $newAvatar = File::create($attributes);
            $request->getAccount()->getUserDetails()->setAvatar($newAvatar)->save();
        } else {
            if (file_exists($oldAvatar->filepath())) {
                unlink($oldAvatar->filepath());
            }

            $newAvatar = $oldAvatar;
            $newAvatar->updateAttributes($attributes);
            $newAvatar->save();
        }

        return UploadAvatarResponse::createSuccessfulResponse($newAvatar);
    }
}
