<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\AccountContext\UseCase\UploadAvatar;

use Application\Core\Model\File;
use Pongho\FileUploader\Exception\FileUploaderException;

class UploadAvatarResponse
{
    /**
     * @var bool
     */
    private $successful = false;

    /**
     * @var File
     */
    private $avatar;

    /**
     * @var FileUploaderException
     */
    private $exception;

    /**
     * @param bool                  $successful
     * @param File                  $avatar
     * @param FileUploaderException $exception
     */
    public function __construct($successful, ?File $avatar = null, ?FileUploaderException $exception = null)
    {
        $this->successful = $successful;
        $this->avatar = $avatar;
        $this->exception = $exception;
    }

    /**
     * @return UploadAvatarResponse
     */
    public static function createSuccessfulResponse(File $avatar)
    {
        return new self(true, $avatar);
    }

    /**
     * @return UploadAvatarResponse
     */
    public static function createFailureResponse(FileUploaderException $exception)
    {
        return new self(true, null, $exception);
    }

    /**
     * @return bool
     */
    public function isSuccessful()
    {
        return $this->successful;
    }

    /**
     * @return File
     */
    public function getAvatar()
    {
        if (!$this->successful) {
            throw new \BadMethodCallException('The avatar model is available only when the result is successful.');
        }

        return $this->avatar;
    }

    /**
     * @return FileUploaderException
     */
    public function getException()
    {
        if ($this->successful) {
            throw new \BadMethodCallException('There are no exception if the result is successful.');
        }

        return $this->exception;
    }
}
