<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\AccountContext\UseCase\UploadAvatar;

use Application\Core\Model\Account;

class UploadAvatarRequest
{
    /**
     * @var Account
     */
    private $account;

    /**
     * @var array
     */
    private $requestFile;

    public function __construct(Account $account, array $requestFile)
    {
        $this->account = $account;
        $this->requestFile = $requestFile;
    }

    /**
     * @return Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * @return array
     */
    public function getRequestFile()
    {
        return $this->requestFile;
    }
}
