<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Foo
 */

namespace Application\Core\Utilities;

/**
 * Permette di renderizzare un indirizzo.
 *
 * @deprecated
 */
class AddressRenderer
{
	/**
	 * Template da utilizzare per il rendering.
	 *
	 * @access protected
	 * @var string
	 */
	protected $template;

	/**
	 * Costruttore.
	 *
	 * @access public
	 * @param string $template
	 */
	public function __construct($template)
	{
		$this->template = $template;
	}

	/**
	 * Renderizza l’indirizzo passato.
	 *
	 * L’indirizzo è un elenco di campi:
	 *
	 * - name
	 * - surname
	 * - address1
	 * - address2
	 * - city
	 * - province
	 * - postcode
	 * - country
	 *
	 * @access public
	 * @param array $address
	 * @return string
	 */
	public function render(array $address)
	{
		$vars = array();
		foreach ( $address as $field => $value )
		{
			$vars['{' . $field . '}'] = $value;
		}

		$code = str_replace(array_keys($vars), array_values($vars), $this->template);
		$code = preg_replace('/[ \t]+/', ' ', $code);
		$code = preg_replace('/[\n\r]+/', "\n", $code);

		return nl2br($code);
	}
}
