<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package ${PACKAGE}
 */

namespace Application\Core\Updates;

use Application\Admin\Model\AdminModule;
use Application\Core\Model\LanguageModule;
use Application\Core\Model\Module;
use Application\Core\Model\ModuleSite;
use Application\Core\Model\Permit;
use Application\Core\Model\PermitRole;
use Application\Core\Model\Translation;
use Updates\BaseUpdate;

class Update29 extends BaseUpdate
{
    public function commit()
    {
        if (!class_exists('Application\\Reminder\\Kernel') && class_exists('Application\\Admin\\Kernel')) {
            // Rimuovo eventuali admin modules
            if ($panel = AdminModule::findPanel('reminder')) {
                foreach ($panel->children() as $item) {
                    $item->delete();
                }
                $panel->delete();
            }

            // Rimuovo eventuali traduzioni
            $options = array(
                'conditions' => array(
                    'pongho_like(`key`, :key) OR application = :application',
                    'key' => '%reminder%',
                    'application' => 'reminders',
                ),
            );
            foreach (Translation::all($options) as $translation) {
                $translation->delete();
            }

            // Rimuovo eventuali module_site, language_module e module
            if ($module = Module::first(array('conditions' => array('controller = :controller', 'controller' => 'Application\\Reminder\\Controller\\ReminderController')))) {
                $options = array(
                    'conditions' => array(
                        'module_id = :module',
                        'module' => $module->id,
                    ),
                );

                foreach (ModuleSite::all($options) as $ms) {
                    $ms->delete();
                }

                foreach (LanguageModule::all($options) as $lm) {
                    $lm->delete();
                }

                $module->delete();
            }
        }
    }
}
