<?php

/**
 * Questo file è parte di pongho-dev.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Translation;
use Updates\BaseUpdate;

/**
 * Update179
 *
 * Nuovi report di Analytics in bacheca.
 */
class Update179 extends BaseUpdate
{
    public function commit()
    {
        $this->fixGoogleApiSettings();

        Translation::deleteTranslation('gapi_configs');
        Translation::deleteTranslation('gapi_configs_explain');
        Translation::deleteTranslation('gapi_profile_id');
    }

    protected function fixGoogleApiSettings()
    {
        $sth = $this->connection->query('SELECT id, settings FROM pongho_sites');

        foreach ($sth as $site) {
            $settings = [];

            if (isset($site['settings'])) {
                $settings = @unserialize($site['settings']);

                if (is_array($settings) && isset($settings['gapi_profile_id'])) {
                    $settings['gapi_view_id'] = $settings['gapi_profile_id'];

                    unset($settings['gapi_profile_id']);
                    unset($settings['gapi_password']);
                }
            }

            $settings['gapi_email'] = '359205235563-2i6j1m3q18bv64hh5pbu8umdocagj4ia@developer.gserviceaccount.com';

            $this->connection->update(
                'pongho_sites',
                [
                    'settings' => serialize($settings)
                ],
                [
                    'id' => $site['id']
                ]
            );
        }
    }
}
