<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Class Update125
 */
class Update125 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $templates_table = $schema->createTable('pongho_notifications_templates');

        $templates_table->addColumn('id', 'integer', array('unsigned' => true, 'autoincrement' => true));
        $templates_table->addColumn('site_id', 'integer', array('unsigned' => true));
        $templates_table->addColumn('notification', 'string', array('length' => 255, 'default' => ''));
        $templates_table->addColumn('sender_to_admin', 'string', array('length' => 255, 'default' => ''));
        $templates_table->addColumn('reply_to_admin', 'string', array('length' => 255, 'default' => ''));
        $templates_table->addColumn('recipient_to_admin', 'string', array('length' => 255, 'default' => ''));
        $templates_table->addColumn('sender_to_user', 'string', array('length' => 255, 'default' => ''));
        $templates_table->addColumn('reply_to_user', 'string', array('length' => 255, 'default' => ''));
        $templates_table->addColumn('recipient_to_user', 'string', array('length' => 255, 'default' => ''));
        $templates_table->addColumn('subject_to_admin', 'string', array('length' => 255, 'default' => ''));
        $templates_table->addColumn('content_to_admin', 'text', array('default' => ''));

        $templates_table->setPrimaryKey(array('id'));
        $templates_table->addForeignKeyConstraint($schema->getTable('pongho_sites'), array('site_id'), array('id'));
        $templates_table->addUniqueIndex(array('site_id', 'notification'));

        // Traduzioni
        $templates_translations_table = $schema->createTable('pongho_notifications_templates_translations');

        $templates_translations_table->addColumn('template_id', 'integer', array('unsigned' => true));
        $templates_translations_table->addColumn('language_id', 'integer', array('unsigned' => true));
        $templates_translations_table->addColumn('subject_to_user', 'string', array('length' => 255, 'default' => ''));
        $templates_translations_table->addColumn('content_to_user', 'text', array('default' => ''));

        $templates_translations_table->setPrimaryKey(array('template_id', 'language_id'));
        $templates_translations_table->addForeignKeyConstraint($templates_table, array('template_id'), array('id'));
        $templates_translations_table->addForeignKeyConstraint($schema->getTable('pongho_languages'), array('language_id'), array('id'));
    }
}
