<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\Mailer\Transport;

use Application\Core\Mailer\Transport\AuthSmtpTransport;

class AuthSmtpTransportTest extends \PHPUnit_Framework_TestCase
{
    public function testInitialize()
    {
        $transport = new AuthSmtpTransport('foo', 'bar');

        $this->assertEquals('foo', $transport->getUsername());
        $this->assertEquals('bar', $transport->getPassword());
        $this->assertEquals('localhost', $transport->getHost());
        $this->assertEquals(25, $transport->getPort());
        $this->assertNull($transport->getEncryption());
    }
}
