<?php
/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var string $action_form
 * @var string $application
 *
 */
?>
<form id="translations" action="<?php echo $action_form; ?>" method="post" class="section checksave">

	<h2><?php echo $translator->trans('Translations'); ?></h2>

	<?php include 'messages.php'; ?>

	<?php include 'tabs.php'; ?>

	<div class="tabsPanel" id="panel-<?php echo $application; ?>">
		<fieldset class="panel">
			<h3><?php echo $translator->trans('%application% translations', array('%application%' => $application)); ?></h3>

            <?php
            if ($application === 'index') {
                include __DIR__ . '/translations_search.php';
            } else {
                include __DIR__ . '/translations_add.php';
            }
            ?>
		</fieldset>

		<fieldset class="btn top">
			<input type="submit" value="<?php echo $translator->trans('Save'); ?>" class="primary save-button" />
		</fieldset>

		<fieldset id="translations-table" class="panel">
            <?php
            if ($application === 'index') {
                include __DIR__ . '/translations_table_search.php';
            } else {
                include __DIR__ . '/translations_table.php';
            }
            ?>
		</fieldset>

		<fieldset class="btn">
			<input type="submit" value="<?php echo $translator->trans('Save'); ?>" class="primary save-button" />
		</fieldset>
	</div>

</form><!-- .section -->
