<?php
/**
 * @var \Application\Core\Localization $lang
 * @var \Application\Core\Utilities\Html $html
 * @var \Application\Core\Model\Site $site
 * @var string $action_form
 */
?><form action="<?php echo $action_form; ?>" method="post" class="section checksave">

	<h2><?php echo $lang->get('options_title'); ?></h2>

	<?php include 'messages.php'; ?>

	<?php include 'tabs.php'; ?>

	<div class="tabsPanel" id="panel-main">
		<fieldset class="panel">
			<h3><?php echo $lang->get('site_configuration'); ?></h3>
			<dl class="extend">
				<dt><label for="field-site-name"><?php echo $lang->get('site_name'); ?></label></dt>
				<dd><input type="text" name="site[name]" id="field-site-name" value="<?php echo $site->name; ?>" class="input_text" /></dd>
			</dl>

			<dl class="extend">
				<dt><label for="field-slogan"><?php echo $lang->get('slogan'); ?></label></dt>
				<dd><input type="text" name="options[slogan]" id="field-slogan" value="<?php echo $value_slogan; ?>" class="input_text" /></dd>
			</dl>

			<dl class="extend">
				<dt><label for="field-site-domain"><?php echo $lang->get('site_domain'); ?></label></dt>
				<dd><input type="text" name="site[domain]" id="field-site-domain" value="<?php echo $site->domain; ?>" class="input_text" /></dd>
			</dl>

			<dl class="extend">
				<dt><label for="field-default-language"><?php echo $lang->get('default_language'); ?></label></dt>
				<dd>
					<select name="site[default_language_id]" id="field-default-language"><?php echo $html->selectLanguage($site->default_language_id); ?></select>
					<span><?php echo $lang->get('default_language_explain'); ?></span>
				</dd>
			</dl>
		</fieldset>

		<fieldset class="panel">
            <h3><?php echo $lang->get('users_configuration'); ?></h3>
            <dl class="extend">
                <dt><label for="field-subscription-mode"><?php echo $lang->get('subscription_mode'); ?></label></dt>
                <dd><select name="options[subscription_mode]" id="field-subscription-mode"><?php echo $html->select(array('email' => $lang->get('subscription_mode_email'), 'simple' => $lang->get('subscription_mode_simple')), $value_subscription_mode); ?></select></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-account_url"><?php echo $lang->get('account_url') ?></label></dt>
                <dd><input type="checkbox" name="options[account_url]" id="field-account_url"<?php echo $value_account_url ? ' checked="checked"' : ''; ?>> <span><?php echo $lang->get('account_url_enable_explain'); ?></span></dd>
            </dl>
		</fieldset>

		<fieldset class="panel">
			<h3>reCAPTCHA</h3>
			<dl class="extend">
				<dt><label for="field-recaptcha"><?php echo $lang->get('recaptcha'); ?></label></dt>
				<dd><input type="checkbox" name="options[recaptcha]" id="field-recaptcha"<?php echo $value_recaptcha ? ' checked="checked"' : ''; ?>> <span><?php echo $lang->get('recaptcha_explain'); ?></span></dd>
			</dl>

			<dl class="extend">
				<dt><label for="field-recaptcha-private-key"><?php echo $lang->get('recaptcha_private_key'); ?></label></dt>
				<dd>
					<input type="text" name="options[recaptcha_private_key]" id="field-recaptcha-private-key" value="<?php echo $value_recaptcha_private_key; ?>" class="input_text" />
					<span><?php echo $lang->get('recaptcha_private_key_explain'); ?></span>
				</dd>
			</dl>

			<dl class="extend">
				<dt><label for="field-recaptcha-public-key"><?php echo $lang->get('recaptcha_public_key'); ?></label></dt>
				<dd><input type="text" name="options[recaptcha_public_key]" id="field-recaptcha-public-key" value="<?php echo $value_recaptcha_public_key; ?>" class="input_text" /></dd>
			</dl>
		</fieldset>

        <fieldset class="panel">
            <h3>reCAPTCHA2 - Chiave specifica per il sito</h3>

            <dl class="extend">
                <dt><label for="field-recaptcha2-private-key"><?php echo $lang->get('recaptcha_private_key'); ?></label></dt>
                <dd><input type="text" name="options[recaptcha2_private_key]" id="field-recaptcha-private-key" value="<?php echo $value_recaptcha2_private_key; ?>" class="input_text" /></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-recaptcha2-public-key"><?php echo $lang->get('recaptcha_public_key'); ?></label></dt>
                <dd><input type="text" name="options[recaptcha2_public_key]" id="field-recaptcha-public-key" value="<?php echo $value_recaptcha2_public_key; ?>" class="input_text" /></dd>
            </dl>

            <h3>reCAPTCHA2 - Chiavi di default per Labs</h3>
            <dl class="extend">
                <dt><label for="field-recaptcha2-labs-private-key"><?php echo $lang->get('recaptcha_private_key'); ?></label></dt>
                <dd><input type="text" name="options[recaptcha2_labs_private_key]" id="field-recaptcha-private-key" value="<?php echo $value_recaptcha2_labs_private_key; ?>" class="input_text" /></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-recaptcha2-labs-public-key"><?php echo $lang->get('recaptcha_public_key'); ?></label></dt>
                <dd><input type="text" name="options[recaptcha2_labs_public_key]" id="field-recaptcha-public-key" value="<?php echo $value_recaptcha2_labs_public_key; ?>" class="input_text" /></dd>
            </dl>
        </fieldset>
    </div>

	<fieldset class="btn">
		<input type="submit" value="<?php echo $lang->get('save'); ?>" class="primary" />
	</fieldset>

</form><!-- .section -->
