<?php

/**
 * @var string $action_form
 * @var string $value_gapi_email
 * @var string $value_gapi_view_id
 * @var string $token
 * @var \Application\Core\I18n\Translation\Translator $translator
 */

?>
<form action="<?php echo $action_form ?>" method="post" class="section">

	<h2><?php echo $lang->options_title ?></h2>

	<?php include 'messages.php' ?>

	<?php include 'tabs.php' ?>

	<div class="tabsPanel" id="panel-dashboard">
		<fieldset class="panel">
			<h3 style="margin-bottom: 8px;"><?php echo $translator->trans('Google Analytics API'); ?></h3>
			<p style="margin-bottom: 16px; padding: 0;"><?php echo $translator->trans('Le Api di Google Analytics vengono usate nella bacheca per visualizzare le statistiche principali del sito. È necessario indicare l’indirizzo e-mail e la password dell’account Google legato al sito e l’ID profilo del sito. Per conoscere quest’ultimo è necessario accedere a Google Analytics, cliccare su “Amministrazione” in alto a destra, selezionare il sito, entrare nel pannello “Profili” ? “Impostazioni profilo” e copiare il campo “ID Profilo”.') ?></p>

			<dl class="extend">
				<dt><label for="field-gapi-email"><?php echo $translator->trans('E-mail address'); ?></label></dt>
				<dd><input type="text" name="options[gapi_email]" id="field-gapi-email" value="<?php echo $value_gapi_email ?>" class="input_text" /></dd>
			</dl>

			<dl class="extend">
				<dt><label for="field-gapi-view-id"><?php echo $translator->trans('View ID'); ?></label></dt>
				<dd><input type="text" name="options[gapi_view_id]" id="field-gapi-view-id" value="<?php echo $value_gapi_view_id ?>" class="input_text" /></dd>
			</dl>
		</fieldset>
	</div>

	<fieldset class="btn">
		<input type="submit" value="<?php echo $lang->save ?>" class="primary" />
	</fieldset>

</form><!-- .section -->
