/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true, white: true */
/*global jQuery, $ */

(function () {
    "use strict";

    // Aggiunge il metodo bind() ai browser che non ce l'hanno di default
    if (!Function.prototype.bind) {
        Function.prototype.bind = function (that) {
            if (typeof this !== 'function') {
                // closest thing possible to the ECMAScript 5
                // internal IsCallable function
                throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');
            }

            var args = Array.prototype.slice.call(arguments, 1),
                ToBind = this,
                NOP = function () {},
                Bound = function () {
                    var t = this instanceof NOP && that ? this : that;
                    return ToBind.apply(t, args.concat(Array.prototype.slice.call(arguments)));
                };

            NOP.prototype = this.prototype;
            Bound.prototype = new NOP();

            return Bound;
        };
    }
}());
