<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * Class UserSubscribeEmailNotification
 */
class UserSubscribeEmailNotification extends UserSubscribeNotification
{
    use HasAccountActivationLinkTrait;

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return 'core.user_subscribe_email';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->translator->trans('User subscribe with email activation');
    }

    /**
     * {@inheritdoc}
     */
    public function getVars()
    {
        $vars = parent::getVars();

        $vars[] = 'USER_ACTIVATION_LINK';

        return $vars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEmailVars()
    {
        $vars = parent::getEmailVars();

        $vars['USER_ACTIVATION_LINK'] = $this->getAccountActivationLink();

        return $vars;
    }
}
