<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * Class NotificationOptions
 */
class NotificationOptions
{
    /**
     * @var boolean
     */
    protected $can_send_to_admin;

    /**
     * @var boolean
     */
    protected $can_send_to_user;

    /**
     * @var boolean
     */
    protected $can_change_sender_to_admin;

    /**
     * @var boolean
     */
    protected $can_change_sender_to_user;

    /**
     * @var boolean
     */
    protected $can_change_recipient_to_admin;

    /**
     * @var boolean
     */
    protected $can_change_recipient_to_user;

    /**
     * @var boolean
     */
    protected $can_reply_to_admin;

    /**
     * @var boolean
     */
    protected $can_reply_to_user;

    /**
     * @var boolean
     */
    protected $can_change_reply_to_admin;

    /**
     * @var boolean
     */
    protected $can_change_reply_to_user;

    /**
     * @param boolean $send_to_admin
     * @param boolean $send_to_user
     * @param boolean $change_sender_to_admin
     * @param boolean $change_sender_to_user
     * @param boolean $change_recipient_to_admin
     * @param boolean $change_recipient_to_user
     * @param boolean $reply_to_admin
     * @param boolean $reply_to_user
     * @param boolean $change_reply_to_admin
     * @param boolean $change_reply_to_user
     */
    function __construct($send_to_admin, $send_to_user, $change_sender_to_admin, $change_sender_to_user, $change_recipient_to_admin, $change_recipient_to_user, $reply_to_admin = false, $reply_to_user = false, $change_reply_to_admin = false, $change_reply_to_user = false)
    {
        $this->can_send_to_admin = $send_to_admin;
        $this->can_send_to_user = $send_to_user;
        $this->can_change_sender_to_admin = $change_sender_to_admin;
        $this->can_change_sender_to_user = $change_sender_to_user;
        $this->can_change_recipient_to_admin = $change_recipient_to_admin;
        $this->can_change_recipient_to_user = $change_recipient_to_user;
        $this->can_reply_to_admin = $reply_to_admin;
        $this->can_reply_to_user = $reply_to_user;
        $this->can_change_reply_to_admin = $change_reply_to_admin;
        $this->can_change_reply_to_user = $change_reply_to_user;
    }

    /**
     * @return boolean
     */
    public function canSendToAdmin()
    {
        return $this->can_send_to_admin;
    }

    /**
     * @return boolean
     */
    public function canSendToUser()
    {
        return $this->can_send_to_user;
    }

    /**
     * @return boolean
     */
    public function canChangeRecipientToAdmin()
    {
        return $this->can_change_recipient_to_admin;
    }

    /**
     * @return boolean
     */
    public function canChangeRecipientToUser()
    {
        return $this->can_change_recipient_to_user;
    }

    /**
     * @return boolean
     */
    public function canChangeSenderToAdmin()
    {
        return $this->can_change_sender_to_admin;
    }

    /**
     * @return boolean
     */
    public function canChangeSenderToUser()
    {
        return $this->can_change_sender_to_user;
    }

    /**
     * @return boolean
     */
    public function canReplyToAdmin()
    {
        return $this->can_reply_to_admin;
    }

    /**
     * @return boolean
     */
    public function canReplyToUser()
    {
        return $this->can_reply_to_user;
    }

    /**
     * @return boolean
     */
    public function canChangeReplyToAdmin()
    {
        return $this->can_change_reply_to_admin;
    }

    /**
     * @return boolean
     */
    public function canChangeReplyToUser()
    {
        return $this->can_change_reply_to_user;
    }
}
