<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */
namespace Application\Core\Notification;

/**
 * Class NotificationConfig
 */
interface NotificationConfigInterface
{
    /**
     * @return string|null
     */
    public function getSenderToAdmin();

    /**
     * @return string|null
     */
    public function getRecipientToAdmin();

    /**
     * @return string|null
     */
    public function getReplyToAdmin();

    /**
     * @return string|null
     */
    public function getSenderToUser();

    /**
     * @return string|null
     */
    public function getRecipientToUser();

    /**
     * @return string|null
     */
    public function getReplyToUser();

    /**
     * @return string|null
     */
    public function getSubjectToAdmin();

    /**
     * @return string|null
     */
    public function getContentToAdmin();

    /**
     * @param string $language_iso
     * @return null|string
     */
    public function getSubjectToUser($language_iso);

    /**
     * @param string $language_iso
     * @return null|string
     */
    public function getContentToUser($language_iso);
}
