<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * Class NotificationCollection
 */
class NotificationCollection implements \IteratorAggregate
{
    protected $collection = array();

    /**
     * @return NotificationInterface[]
     */
    public function getIterator()
    {
        return new \ArrayIterator($this->collection);
    }

    /**
     * @param NotificationInterface $notification
     * @return $this
     */
    public function add(NotificationInterface $notification)
    {
        $this->collection[$notification->getName()] = $notification;

        return $this;
    }

    /**
     * @param $name
     * @return NotificationInterface
     */
    public function get($name)
    {
        if (!isset($this->collection[$name])) {
            throw new \InvalidArgumentException('The notification "' . $name . '" does not exists');
        }

        return $this->collection[$name];
    }

    /**
     * @param string $name
     * @return bool
     */
    public function has($name)
    {
        return isset($this->collection[$name]);
    }

    /**
     * @param string $name
     * @return $this
     */
    public function del($name)
    {
        unset($this->collection[$name]);

        return $this;
    }
}
