<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;
use Application\Core\Entity\ProvinceInterface;
use Application\Core\Entity\RegionInterface;
use Application\Core\Model\Manager\ProvinceManager;
use Pongho\Core\Kernel;

/**
 * Modello per le regioni.
 *
 * @property int    $id
 * @property string $name
 * @property string $name_long
 * @property string $url
 */
class Region extends Base implements RegionInterface
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'regions';

    /**
     * __toString
     *
     * @return string
     */
    public function __toString()
    {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getLongName()
    {
        return $this->name_long;
    }

    /**
     * @return string
     */
    public function getSlug()
    {
        return $this->url;
    }

    /**
     * @return ProvinceInterface[]
     */
    public function getProvinces()
    {
        /** @var ProvinceManager $manager */
        $manager = Kernel::instance()->getContainer()->get('province_manager');

        return $manager->findByRegion($this->id);
    }
}
