<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\LanguageInterface;
use Application\Core\Entity\NotificationTemplateInterface;

/**
 * Interface NotificationTemplateManagerInterface
 */
interface NotificationTemplateManagerInterface
{
    /**
     * @param int               $id
     * @param LanguageInterface $language
     * @return NotificationTemplateInterface
     */
    public function findById($id, LanguageInterface $language = null);

    /**
     * @param string            $notification_name
     * @param LanguageInterface $language
     * @return NotificationTemplateInterface
     */
    public function findByNotification($notification_name, LanguageInterface $language= null);

    /**
     * @param array             $conditions
     * @param string            $order_by
     * @param int               $limit
     * @param int               $offset
     * @return NotificationTemplateInterface[]
     */
    public function findAll(array $conditions = array(), $order_by = null, $limit = null, $offset = null);

    /**
     * Serve per l'eventuale paginazione in backend
     *
     * @param array $conditions
     * @return int
     */
    public function countAll(array $conditions = array());
}
