<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\ModuleInterface;
use Application\Core\Entity\ModuleSiteInterface;
use Application\Core\Entity\SiteInterface;

/**
 * Interface ModuleSiteManagerInterface
 */
interface ModuleSiteManagerInterface
{
    /**
     * @return ModuleSiteInterface[]
     */
    public function findAll();

    /**
     * @param int $site_id
     * @return ModuleSiteInterface[]
     */
    public function findAllBySite($site_id);

    /**
     * @param int $module_id
     * @return ModuleSiteInterface[]
     */
    public function findAllByModule($module_id);

    /**
     * @param int $module_site_id
     * @return ModuleSiteInterface
     */
    public function findById($module_site_id);

    /**
     * @param int $site_id
     * @param int $module_id
     * @return ModuleSiteInterface
     */
    public function findBySiteAndModule($site_id, $module_id);

    /**
     * @param int|ModuleInterface $module
     * @param int|SiteInterface   $site
     * @param boolean             $is_enabled
     * @param array               $settings
     * @return ModuleSiteInterface
     */
    public function create($module, $site, $is_enabled, array $settings = array());

    /**
     * @param ModuleSiteInterface $module_site
     * @return $this
     */
    public function save(ModuleSiteInterface $module_site);
}
