<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\AccountInterface;
use Application\Core\Entity\UserDetailsInterface;

/**
 * Interface AccountManagerInterface
 */
interface AccountManagerInterface
{
    /**
     * @param int $id
     * @return AccountInterface|UserDetailsInterface
     */
    public function findById($id);

    /**
     * @param string $email
     * @return AccountInterface|UserDetailsInterface
     */
    public function findByEmail($email);

    /**
     * @param string $username
     * @return AccountInterface|UserDetailsInterface
     */
    public function findByUsername($username);

    /**
     * @param string $token
     * @return AccountInterface|UserDetailsInterface
     */
    public function findByResetPasswordToken($token);

    /**
     * @param string $url
     * @return AccountInterface|UserDetailsInterface
     */
    public function findByUrl($url);

    /**
     * @param int|AccountInterface $descendant
     * @param int|AccountInterface $current_account
     * @param bool                 $can_view_all_users
     * @return mixed
     */
    public function findAncestorsByDescendant($descendant, $current_account = null, $can_view_all_users = true);

    /**
     * @param AccountInterface $account
     */
    public function save(AccountInterface $account);
}
