<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;

/**
 * Modello per le relazioni tra account e gruppi.
 *
 * @property int                             $group_id
 * @property int                             $user_id
 * @property \Application\Core\Model\Account $user
 */
class GroupUser extends Base
{
    /**
     * Nome della tabella.
     *
     * @static
     * @var string
     */
    public static $table_name = 'groups_users';

    /**
     * Chiave primaria.
     *
     * @static
     * @var string|array
     */
    public static $primary_key = array('group_id', 'user_id');

    /**
     * Relazioni 'belongs_to'.
     *
     * @var array
     * @static
     */
    public static $belongs_to = array(
        array('user', 'model' => 'Application\\Core\\Model\\Account'),
    );
}
